<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('boats', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('boat_models')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('boat_models', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('boat_type_id')->references('id')->on('boats')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('boats', function(Blueprint $table) {
			$table->dropForeign('boats_model_id_foreign');
		});
		Schema::table('boat_models', function(Blueprint $table) {
			$table->dropForeign('boat_models_brand_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_contact_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_brand_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_boat_type_id_foreign');
		});
	}
}