<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillingDatasTable extends Migration {

	public function up()
	{
		Schema::create('billing_datas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('registered_name');
			$table->string('email');
			$table->string('phone');
			$table->integer('country_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->string('address');
			$table->string('postal_code');
			$table->string('identification_number');
			$table->integer('payment_method_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('billing_datas');
	}
}