<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('date_start')->nullable();
			$table->datetime('date_end')->nullable();
			$table->string('date_text')->nullable();
			$table->integer('stock')->nullable();
			$table->integer('support_id')->unsigned();
			$table->integer('format_id')->unsigned();
			$table->integer('image_id')->unsigned();
			$table->integer('contracttype_id')->unsigned();
			$table->integer('metadata_id')->unsigned();
			$table->integer('price_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}