<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceServicesTable extends Migration {

	public function up()
	{
		Schema::create('invoice_services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('service_id')->unsigned();
			$table->integer('metadata_id')->unsigned();
			$table->decimal('price', 14,4);
			$table->decimal('discount', 8,2);
			$table->decimal('tax', 8,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice_services');
	}
}