<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMetadataTable extends Migration {

	public function up()
	{
		Schema::create('metadata', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->unique();
			$table->text('internal_note')->nullable();
			$table->integer('default_value')->unsigned()->nullable();
			$table->boolean('active')->nullable()->default(true);
			$table->boolean('private')->nullable();
			$table->string('slug')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('metadata');
	}
}