<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupportsTable extends Migration {

	public function up()
	{
		Schema::create('supports', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id')->unsigned();
			$table->integer('language_id')->unsigned();
			$table->integer('billing_data_id')->unsigned();
			$table->integer('image_id')->unsigned()->nullable();
			$table->integer('metadata_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('supports');
	}
}