<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceReservationsTable extends Migration {

	public function up()
	{
		Schema::create('invoice_reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('invoice_id')->unsigned();
			$table->decimal('price', 14,4);
			$table->integer('metadata_id')->unsigned();
			$table->integer('reservation_id')->unsigned();
			$table->decimal('qty', 8,2)->nullable()->default('1');
			$table->decimal('discount', 14,4)->nullable();
			$table->decimal('tax', 8,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice_reservations');
	}
}