<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLayoutsTable extends Migration {

	public function up()
	{
		Schema::create('layouts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('metadata_id')->unsigned();
			$table->string('template')->nullable();
			$table->boolean('mail')->nullable();
			$table->boolean('page')->nullable();
			$table->boolean('alert')->nullable();
			$table->boolean('contract')->nullable();
			$table->boolean('invoice')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('layouts');
	}
}