<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('UUID')->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->string('email')->unique();
			$table->string('password');
			$table->integer('image_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}