<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSearchesTable extends Migration {

	public function up()
	{
		Schema::create('searches', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('text')->nullable();
			$table->integer('category_id')->unsigned()->nullable();
			$table->datetime('date_start')->nullable();
			$table->datetime('date_end')->nullable();
			$table->integer('format_id')->unsigned()->nullable();
			$table->integer('session_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('searches');
	}
}