<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserMovementsTable extends Migration {

	public function up()
	{
		Schema::create('user_movements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->decimal('amount', 14,4);
			$table->boolean('spending')->nullable();
			$table->boolean('entry')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_movements');
	}
}