<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('duration_id')->references('id')->on('durations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cours_room', function(Blueprint $table) {
			$table->foreign('cours_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cours_room', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cours_student', function(Blueprint $table) {
			$table->foreign('cours_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cours_student', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('registers', function(Blueprint $table) {
			$table->foreign('cours_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_teacher_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_category_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_duration_id_foreign');
		});
		Schema::table('cours_room', function(Blueprint $table) {
			$table->dropForeign('cours_room_cours_id_foreign');
		});
		Schema::table('cours_room', function(Blueprint $table) {
			$table->dropForeign('cours_room_room_id_foreign');
		});
		Schema::table('cours_student', function(Blueprint $table) {
			$table->dropForeign('cours_student_cours_id_foreign');
		});
		Schema::table('cours_student', function(Blueprint $table) {
			$table->dropForeign('cours_student_student_id_foreign');
		});
		Schema::table('registers', function(Blueprint $table) {
			$table->dropForeign('registers_cours_id_foreign');
		});
	}
}