<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BallotSubmission extends Model 
{

    protected $table = 'BallotSubmission';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('electionID', 'selection', 'email');
    protected $visible = array('electionID', 'selection', 'email');

    public function election()
    {
        return $this->belongsTo('ElectionDefinition', 'id', 'id');
    }

}