<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormDefinitionTable extends Migration {

	public function up()
	{
		Schema::create('FormDefinition', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('groupID')->unsigned();
			$table->integer('userID')->unsigned();
			$table->datetime('submissionsStart');
			$table->datetime('submissionsEnd');
			$table->datetime('scoresDue');
			$table->text('fields')->default('{}');
			$table->enum('status', array('Draft', 'Scheduled', 'Open', 'Review', 'Committe', 'Archived'));
		});
	}

	public function down()
	{
		Schema::drop('FormDefinition');
	}
}