<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldTable extends Migration {

	public function up()
	{
		Schema::create('field', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('options');
			$table->boolean('required')->default(false);
			$table->enum('type', array('text', 'email', 'select', 'radios', 'checkboxes', 'file'));
		});
	}

	public function down()
	{
		Schema::drop('field');
	}
}