<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SubmissionScore extends Eloquent {

	protected $table = 'SubmissionScore';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('score', 'comment', 'status', 'submission_id');
	protected $visible = array('score', 'comment', 'status', 'submission_id');

	public function submission()
	{
		return $this->belongsTo('ApplicationSubmission');
	}

}