<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->decimal('price', 9,2);
			$table->boolean('allow_peer_to_peer');
			$table->boolean('allow_recurring');
			$table->decimal('fee_percentage');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('require_own_psp');
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}