<?php

namespace Supp;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function subscription()
	{
		return $this->morphOne('Supp\Subscription');
	}

	public function package()
	{
		return $this->belongsTo('Supp\Package');
	}

}