<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('objects', function(Blueprint $table) {
			$table->foreign('object_type_id')->references('id')->on('object_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_objects', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_objects', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('object_images', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_checkins', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('objects', function(Blueprint $table) {
			$table->dropForeign('objects_object_type_id_foreign');
		});
		Schema::table('user_objects', function(Blueprint $table) {
			$table->dropForeign('user_objects_user_id_foreign');
		});
		Schema::table('user_objects', function(Blueprint $table) {
			$table->dropForeign('user_objects_object_id_foreign');
		});
		Schema::table('object_images', function(Blueprint $table) {
			$table->dropForeign('object_images_object_id_foreign');
		});
		Schema::table('user_checkins', function(Blueprint $table) {
			$table->dropForeign('user_checkins_user_id_foreign');
		});
	}
}