<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Blog extends Eloquent {

	protected $table = 'blogs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function commentsposted()
	{
		return $this->hasMany('Comment', 'blog_id');
	}

	public function likesposted()
	{
		return $this->hasMany('LikeUser', 'entity_id');
	}

}