<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Image extends Eloquent {

	protected $table = 'images';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function blogimage()
	{
		return $this->belongsTo('Blog', 'entity_id');
	}

	public function commentimage()
	{
		return $this->belongsTo('Comment', 'entity_id');
	}

}