<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCheckItemTable extends Migration {

	public function up()
	{
		Schema::create('check_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('check_list_id')->nullable();
			$table->text('description')->nullable();
			$table->boolean('completed')->nullable()->default(0);
			$table->integer('created_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('check_item');
	}
}