<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupInvitationTable extends Migration {

	public function up()
	{
		Schema::create('group_invitation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('group_id')->nullable();
			$table->integer('member_id')->nullable();
			$table->integer('sender_id')->nullable();
			$table->enum('status', array('pending', 'accepted', 'rejected'))->nullable();
			$table->boolean('approve')->nullable()->default(1);
		});
	}

	public function down()
	{
		Schema::drop('group_invitation');
	}
}