<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('post_type', array('post', 'shareknowladge', 'news', 'announcement', 'newhire', 'compaign', 'alert'))->nullable();
			$table->integer('created_by')->nullable();
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->datetime('expire_at')->nullable();
			$table->boolean('confirm_report')->nullable()->default(1);
			$table->string('letter_number')->nullable();
			$table->integer('alert_type_id')->nullable();
			$table->boolean('all_member')->nullable()->default(1);
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}