<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTable extends Migration {

	public function up()
	{
		Schema::create('company', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->text('about_en')->nullable();
			$table->text('about_ar')->nullable();
			$table->text('words_en')->nullable();
			$table->text('words_ar')->nullable();
			$table->text('policy_en')->nullable();
			$table->text('policy_ar')->nullable();
			$table->text('vision_en')->nullable();
			$table->text('vision_ar')->nullable();
			$table->text('mission_en')->nullable();
			$table->text('mission_ar')->nullable();
			$table->integer('total_hours')->nullable();
			$table->integer('folder_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('company');
	}
}