<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationTable extends Migration {

	public function up()
	{
		Schema::create('notification', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('member_id')->nullable();
			$table->text('message')->nullable();
			$table->boolean('read')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('notification');
	}
}