<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CalendarWord extends Eloquent {

	protected $table = 'calendar_word';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('description', 'from_date', 'to_date', 'hide', 'member_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}