<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ChatMessage extends Eloquent {

	protected $table = 'chat_message';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('sender_id', 'message', 'chat_id');

	public function chat()
	{
		return $this->belongsTo('Chat', 'chat_id');
	}

	public function sender()
	{
		return $this->belongsTo('Member', 'sender_id');
	}

	public function read()
	{
		return $this->belongsToMany('Member', 'chat_read', 'member_id', 'chat_message_id');
	}

}