<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ChatRead extends Eloquent {

	protected $table = 'chat_read';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'chat_message_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function chat_message()
	{
		return $this->belongsTo('ChatMessage', 'chat_message_id');
	}

}