<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Followers extends Eloquent {

	protected $table = 'followers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'follower_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function follower()
	{
		return $this->belongsTo('Member', 'follower_id');
	}

}