<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GroupRate extends Eloquent {

	protected $table = 'group_rate';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('group_id', 'member_id', 'rate', 'review');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function group()
	{
		return $this->belongsTo('Group', 'group_id');
	}

}