<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GroupTag extends Eloquent {

	protected $table = 'group_tag';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('tag_id', 'group_id');

	public function group()
	{
		return $this->belongsTo('Group', 'group_id');
	}

	public function tag()
	{
		return $this->belongsTo('Tag', 'tag_id');
	}

}