<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Note extends Eloquent {

	protected $table = 'note';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'title', 'description', 'date', 'from_hour', 'to_hour');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}