<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostMember extends Eloquent {

	protected $table = 'post_member';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_id', 'member_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

}