<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectHistory extends Eloquent {

	protected $table = 'project_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'created_by', 'description');

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

}