<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TaskFollower extends Eloquent {

	protected $table = 'task_follower';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'task_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function task()
	{
		return $this->belongsTo('Task', 'task_id');
	}

}