<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('firstname', 200);
			$table->string('lastname', 200);
			$table->string('email', 200);
			$table->string('password', 200);
			$table->timestamp('created');
			$table->string('updated');
			$table->string('deleted');
			$table->smallInteger('soft_delete');
			$table->enum('type', array('store_owner', 'employee'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}