<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('store_id')->unsigned();
			$table->float('total_price');
			$table->timestamp('delivery_date');
			$table->string('delivery_address1', 200);
			$table->string('delivery_address2', 200);
			$table->string('delivery_city', 200);
			$table->string('delivery_state', 200);
			$table->string('delivery_country', 200);
			$table->string('delivery_zipcode', 200);
			$table->timestamp('created');
			$table->timestamp('updated');
			$table->timestamp('deleted');
			$table->smallInteger('soft_delete');
			$table->integer('ordertaken_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}