<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cart extends Model 
{

    protected $table = 'carts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getCustomer()
    {
        return $this->belongsTo('App\Customer');
    }

    public function getCoupon()
    {
        return $this->belongsTo('App\Coupon');
    }

}