<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserCoupon extends Model 
{

    protected $table = 'customer_coupons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getCoupon()
    {
        return $this->belongsTo('App\Coupon');
    }

    public function getCustomer()
    {
        return $this->belongsTo('App\Customer');
    }

}