<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGeneralSettingsTable extends Migration {

	public function up()
	{
		Schema::create('general_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('logo');
			$table->string('facebook_logo');
			$table->string('instagram_logo')->nullable();
			$table->string('twitter_logo')->nullable();
			$table->string('linked_logo')->nullable();
			$table->string('facebook');
			$table->string('instagram');
			$table->string('twitter');
			$table->string('linked_in');
			$table->string('contact_number_1');
			$table->string('contact_number_2');
			$table->string('email');
			$table->string('copyright_text');
			$table->string('control_panel_title');
			$table->string('seo_url')->nullable();
			$table->string('meta_title')->nullable();
			$table->string('meta_tag')->nullable();
			$table->string('meta_description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('general_settings');
	}
}