<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGiftCardOrdersTable extends Migration {

	public function up()
	{
		Schema::create('gift_card_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('type');
			$table->bigInteger('gift_card_Id');
			$table->bigInteger('customer_id')->unsigned();
			$table->decimal('total_amount');
			$table->enum('payment_status', array(''Pending'', ''Paid'', ''Cancelled''));
			$table->string('recipient_name')->nullable();
			$table->string('recipient_email')->nullable();
			$table->string('sender_name')->nullable();
			$table->string('phone');
			$table->date('valid_from');
			$table->date('valid_to');
			$table->string('message')->nullable();
			$table->date('delivery_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('gift_card_orders');
	}
}