<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductAttribute extends Model 
{

    protected $table = 'product_attributes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getProducts()
    {
        return $this->belongsTo('App\Product');
    }

    public function getAttributes()
    {
        return $this->belongsTo('App\Attribute');
    }

}