<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('identifier', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->string('created_by_user_id')->nullable();
			$table->string('status_id')->nullable();
			$table->longText('description')->nullable();
			$table->datetime('closed_date')->nullable();
			$table->string('status_reason', 255)->nullable();
			$table->longText('note')->nullable();
			$table->integer('project_type_id');
			$table->tinyInteger('tracker_issues')->nullable();
			$table->tinyInteger('tracker_support')->nullable();
			$table->tinyInteger('gitlab')->nullable();
			$table->string('customer_id')->nullable();
			$table->integer('priority_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}