<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActionsTable extends Migration {

	public function up()
	{
		Schema::create('actions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('task_id')->nullable();
			$table->float('time_spent', 16,2)->nullable();
			$table->integer('action_type_id')->nullable();
			$table->tinyInteger('billable')->nullable();
			$table->integer('created_by_user_id')->nullable();
			$table->longText('description')->nullable();
			$table->datetime('action_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('actions');
	}
}