<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRemindersTable extends Migration {

	public function up()
	{
		Schema::create('reminders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('task_id')->nullable();
			$table->integer('project_id');
			$table->tinyInteger('sent');
			$table->string('recipient_user_id')->nullable();
			$table->integer('created_by_user_id');
			$table->longText('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reminders');
	}
}