<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('brand_id')->unsigned();
			$table->string('name');
			$table->text('desc')->nullable();
			$table->string('price');
			$table->json('custom_fields')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}