<?php

namespace QuotationPrice;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuotationPrice extends Eloquent {

	protected $table = 'QuotationPrices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function customer()
	{
		return $this->hasOne('ContactPerson');
	}

	public function company()
	{
		return $this->hasOne('Company');
	}

	public function products()
	{
		return $this->hasManyThrough('Product', 'OrderProduct');
	}

}