<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('address');
			$table->string('phone');
			$table->string('email');
			$table->string('website');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('logo');
			$table->string('tax_no');
			$table->integer('city_id');
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}