<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('phone');
			$table->string('email');
			$table->string('logo')->nullable();
			$table->string('password');
			$table->enum('role', array(''));
			$table->timestamps();
			$table->softDeletes();
			$table->string('employee_title');
			$table->integer('city_id');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}